<?php

namespace YOOtheme\Theme\Widgets\Listener;

use YOOtheme\Config;
use YOOtheme\Metadata;
use YOOtheme\Path;
use function YOOtheme\app;

class LoadWidgetsScreen
{
    public static function handle($screen)
    {
        if (!in_array($screen->base, ['customize', 'widgets'])) {
            return;
        }

        [$config, $metadata] = app(Config::class, Metadata::class);

        $metadata->set(
            'script:widgets-data',
            sprintf('var $widgets = %s;', file_get_contents(Path::get('../../config/widgets.json')))
        );

        if ($screen->base === 'widgets') {
            $debug = $config('app.debug') ? '' : '.min';
            $metadata->set('script:uikit', ['src' => "~assets/uikit/dist/js/uikit{$debug}.js"]);
            $metadata->set('script:widgets', ['src' => Path::get('../../app/widgets.min.js')]);
        }
    }
}
