<?php

namespace YOOtheme\Theme\Wordpress\Listener;

use YOOtheme\Http\Request;
use YOOtheme\Http\Response;

class CheckUserCapability
{
    /**
     * Check capability of current user.
     *
     * @param Request  $request
     * @param callable $next
     */
    public static function handle($request, callable $next): Response
    {
        // check user capabilities
        if (!$request->getAttribute('allowed') && !current_user_can('edit_theme_options')) {
            $request->abort(403, 'Insufficient User Rights.');
        }

        return $next($request);
    }
}
